<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class ENGAGESSMS_sms
{
    var $sms;
    var $url;
    var $api_key;
    var $api_secret;
    var $from;
    var $template_id;

    public function __construct()
    {
        $this->url = 'https://sms.api.engagelab.cc/v1/send';

        $sms_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "sms where is_effect = 1");

        if ($sms_info) {
            $sms_info['config'] = unserialize($sms_info['config']);

            $this->from = $sms_info['config'][0];
            $this->api_key = $sms_info['user_name'];
            $this->template_id = $sms_info['config'][0];
            $this->api_secret = $sms_info['password'];
        }
    }


    public function sendSms($mobiles, $content, $sendTime = '', $is_adv = 0, $code)
    {
        if (app_conf("SMS_ON") == 0) {
            return array(
                "status" => 0,
                "msg"    => 'The website does not turn on the SMS function.',
            );
        }


        if (!is_array($mobiles)){
            $phone_number = preg_split("/[ ,]/i", $mobiles);
        }else{
            $phone_number = $mobiles[0];
        }

        if(substr($mobiles, 0, 1) !== '+') {
            $phone_number = '+' . $phone_number;
        }

        if (count($phone_number) > 0) {
            $url = $this->url;
            $para = array(
                //"from" => "xxxx",
                "to"   => [$phone_number],
                //"request_id" => "123",
                "body" => array(
                    "template_id" => $this->template_id,  // 882182 $this->template_id
                    //"label_id"    => 231,
                    "vars"        => array(
                        "code" => $code
                    )
                )
            );
            $result = $this->https_request($url, $para);

        } else {
            $result['status'] = 0;
            $result['msg'] = "No mobile phone number sent.";
        }

        return $result;
    }


    public function https_request($url, $para)
    {

        $devKey = $this->api_key; // 替换为您的 Dev Key
        $devSecret = $this->api_secret; // 替换为您的 Dev Secret
        $authString = base64_encode($devKey . ':' . $devSecret);

        $data_string = json_encode($para);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                "Authorization: Basic " . $authString,
                "Content-Type: application/json",
                "Content-Length: " . strlen($data_string))
        );

        $response = curl_exec($ch);
        curl_close($ch);

        $data_val = json_decode($response, true);

        //  . '-----' . json_encode($para)
        add_file_log('request:' . $data_string . '----response:' . $response, 'engages_sms_api', 'sms');

        $data = array();
        if (isset($data_val['code'])) {
            $data['status'] = 0;
            $data['msg'] = $data_val['message'];
            $data['message_id'] = '';
        } else {
            $data['status'] = 1;
            $data['msg'] = 'OK';
        }

        return $data;
    }
}