<?php
/**
 * 布谷科技商业系统
 * 容联云短信
 * @author 山东布谷鸟网络科技有限公司
 * @create 2020-10-13 10:39
 */

// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------

/* 模块的基本信息 */
if (isset($read_modules) && $read_modules == true) {
    $module['server_url'] = 'https://www.yuntongxun.com/';

    $module['class_name'] = 'RONG';
    /* 名称 */
    $module['name'] = "容联云短信平台";

    if (ACTION_NAME == "install" || ACTION_NAME == "edit") {
        $install_info = [
            'lang' => ['国际模板ID', '国内模板ID', '签名', '国际应用APPID', '国内应用APPID'],
            'config' => [['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0]]
        ];
        $module['lang'] = $install_info['lang'];
        $module['config'] = $install_info['config'];
    }
    return $module;
}

// 企信通短信平台
require_once APP_ROOT_PATH . "system/libs/sms.php";
require_once APP_ROOT_PATH . "system/sms/rong/SmsSDK.php";

class RONG_sms implements sms
{
    public $sms;
    public $message = "";

    public function __construct($smsInfo = '')
    {
        if (!empty($smsInfo)) {
            $this->sms = $smsInfo;
        }
    }

    public function sendSMS($mobile_number, $content, $sendTime = '', $is_adv = 0, $code = 0)
    {
        if (is_array($mobile_number)) {
            $mobile_number = implode(",", $mobile_number);
        }

        $this->sms['mobile'] = $mobile_number;
        $this->sms['content'] = urlencode($content);

        if ($is_adv == 1) {
            $this->sms['is_adv'] = 1;
        } else {
            $this->sms['is_adv'] = 0;
        }

        $params = json_encode($this->sms);

        $datas = [$code];

        //主帐号
        $accountSid = $this->sms['user_name'];
        //主帐号Token
        $accountToken = $this->sms['password'];
        //应用Id
        $appId = $this->sms['config'][3];
        //请求地址，格式如下，不需要写https://,默认为：app.cloopen.com'
        $serverIP = 'app.cloopen.com';
        //请求端口 默认为：8883
        $serverPort = '8883';
        //REST版本号 默认为：2013-12-26
        $softVersion = '2013-12-26';

        // 发送模板短信
        //echo "Sending TemplateSMS to $mobile_number <br/>";
        $temp_id = $this->sms['config'][0];
        if (strpos($mobile_number, '0086') !== false) {
            $temp_id = $this->sms['config'][1];
            $appId = $this->sms['config'][4];
        }

        // 初始化REST SDK
        $rest = new REST($serverIP, $serverPort, $softVersion);
        $rest->setAccount($accountSid, $accountToken);
        $rest->setAppId($appId);

        $api_result = $rest->sendTemplateSMS($mobile_number, $datas, $temp_id);
        if ($api_result == NULL) {
            $result['status'] = 0;
            $result['msg'] = 'result error!';
        }
        if ($api_result->statusCode != 0) {
            $result['status'] = $api_result->statusCode;
            $result['msg'] = '错误码：' . $api_result->statusCode . '错误信息:' . $api_result->statusMsg;
        } else {
            // 获取返回信息
            $result['status'] = 1;
            $result['msg'] = '发送成功';
        }

        return $result;
    }

    public function getSmsInfo()
    {
        return "云通讯短信";
    }

    public function check_fee()
    {
        $str = '暂无接口！';
    }
}

?>