<?php
/**
 * 布谷科技商业系统
 * 容联云短信
 * @author 山东布谷鸟网络科技有限公司
 * @create 2020-10-13 10:39
 */

// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------

/* 模块的基本信息 */
if (isset($read_modules) && $read_modules == true) {
    $module['server_url'] = 'https://cloud.tencent.com/document/product/382';

    $module['class_name'] = 'TENCENT';
    /* 名称 */
    $module['name'] = "Tencen SMS";

    if (ACTION_NAME == "install" || ACTION_NAME == "edit") {
        $install_info = [
            'lang' => ['International_SmsSdkAppid', 'International_Sign', 'International_SenderId', 'International_TemplateID',
                'China_SmsSdkAppid', 'China_Sign', 'China_TemplateID'],
            'config' => [['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0],]
        ];
        $module['lang'] = $install_info['lang'];
        $module['config'] = $install_info['config'];
    }
    return $module;
}

// 企信通短信平台
require_once APP_ROOT_PATH . "system/libs/sms.php";

//require_once '../../../TCloudAutoLoader.php';

// 导入 SMS 的 client
use TencentCloud\Sms\V20190711\SmsClient;

// 导入要请求接口对应的 Request 类
use TencentCloud\Sms\V20190711\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;

// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;


class TENCENT_sms implements sms
{
    public $sms;
    public $message = "";

    public function __construct($smsInfo = '')
    {
        if (!empty($smsInfo)) {
            $this->sms = $smsInfo;
        }
    }

    public function sendSMS($mobile_number, $content, $sendTime = '', $is_adv = 0, $code = 0)
    {
        if (is_array($mobile_number)) {
            $mobile_number = implode(",", $mobile_number);
        }

        $this->sms['mobile'] = $mobile_number;
        $this->sms['content'] = urlencode($content);

        if ($is_adv == 1) {
            $this->sms['is_adv'] = 1;
        } else {
            $this->sms['is_adv'] = 0;
        }

        $params = json_encode($this->sms);

        $secretId = $this->sms['user_name'];
        $secretKey = $this->sms['password'];

        $smsSdkAppid = $this->sms['config'][0];
        $sign = $this->sms['config'][1];
        $senderId = $this->sms['config'][2];
        $templateID = $this->sms['config'][3];

        if (strpos($mobile_number, '+86') !== false) {
            //国内短信
            $smsSdkAppid = $this->sms['config'][4];
            $sign = $this->sms['config'][5];
            $senderId = '';
            $templateID = $this->sms['config'][6];
        }
        try {
            /* 必要步骤：
             * 实例化一个认证对象，入参需要传入腾讯云账户密钥对 secretId 和 secretKey
             * 本示例采用从环境变量读取的方式，需要预先在环境变量中设置这两个值
             * 您也可以直接在代码中写入密钥对，但需谨防泄露，不要将代码复制、上传或者分享给他人
             * CAM 密钥查询：https://console.cloud.tencent.com/cam/capi
             */
            $cred = new Credential($secretId, $secretKey);
            //$cred = new Credential(getenv("TENCENTCLOUD_SECRET_ID"), getenv("TENCENTCLOUD_SECRET_KEY"));
            // 实例化一个 http 选项，可选，无特殊需求时可以跳过
            $httpProfile = new HttpProfile();
            $httpProfile->setReqMethod("GET");  // POST 请求（默认为 POST 请求）
            $httpProfile->setReqTimeout(30);    // 请求超时时间，单位为秒（默认60秒）
            $httpProfile->setEndpoint("sms.tencentcloudapi.com");  // 指定接入地域域名（默认就近接入）
            // 实例化一个 client 选项，可选，无特殊需求时可以跳过
            $clientProfile = new ClientProfile();
            $clientProfile->setSignMethod("TC3-HMAC-SHA256");  // 指定签名算法（默认为 HmacSHA256）
            $clientProfile->setHttpProfile($httpProfile);
            // 实例化 SMS 的 client 对象，clientProfile 是可选的
            $client = new SmsClient($cred, "ap-shanghai", $clientProfile);
            // 实例化一个 sms 发送短信请求对象，每个接口都会对应一个 request 对象。
            $req = new SendSmsRequest();
            /* 填充请求参数，这里 request 对象的成员变量即对应接口的入参
            * 您可以通过官网接口文档或跳转到 request 对象的定义处查看请求参数的定义
            * 基本类型的设置:
              * 帮助链接：
              * 短信控制台：https://console.cloud.tencent.com/smsv2
              * sms helper：https://cloud.tencent.com/document/product/382/3773 */
            /* 短信应用 ID: 在 [短信控制台] 添加应用后生成的实际 SDKAppID，例如1400006666 */
            $req->SmsSdkAppid = $smsSdkAppid;
            /* 短信签名内容: 使用 UTF-8 编码，必须填写已审核通过的签名，可登录 [短信控制台] 查看签名信息 */
            $req->Sign = $sign;
            /* 短信码号扩展号: 默认未开通，如需开通请联系 [sms helper] */
            $req->ExtendCode = "0";
            /* 下发手机号码，采用 e.164 标准，+[国家或地区码][手机号]
            * 例如+8613711112222， 其中前面有一个+号 ，86为国家码，13711112222为手机号，最多不要超过200个手机号*/
            $req->PhoneNumberSet = array($mobile_number);
            /* 国际/港澳台短信 senderid: 国内短信填空，默认未开通，如需开通请联系 [sms helper] */
            $req->SenderId = $senderId;
            /* 用户的 session 内容: 可以携带用户侧 ID 等上下文信息，server 会原样返回 */
            //$req->SessionContext = "xxx";
            /* 模板 ID: 必须填写已审核通过的模板 ID。可登录 [短信控制台] 查看模板 ID */
            $req->TemplateID = $templateID;
            /* 模板参数: 若无模板参数，则设置为空*/
            $req->TemplateParamSet = array($code);
            // 通过 client 对象调用 Sen dSms 方法发起请求。注意请求方法名与请求对象是对应的
            $api_result = $client->SendSms($req);
            // 输出 JSON 格式的字符串回包
            //print_r($api_result->toJsonString());
            // 可以取出单个值，您可以通过官网接口文档或跳转到 response 对象的定义处查看返回字段的定义
            //print_r($api_result->TotalCount);
        } catch (TencentCloudSDKException $e) {
            $result['status'] = 0;
            $result['msg'] = $e->getMessage();
            return $result;
        }

        if ($api_result == NULL) {
            $result['status'] = 0;
            $result['msg'] = 'result error!';
        }
        $SendStatus = $api_result->SendStatusSet[0];

        if ($SendStatus->Code != 'Ok') {
            $result['status'] = $SendStatus->Code;
            $result['msg'] = '错误码：' . $SendStatus->Code . '错误信息:' . $SendStatus->CodeMessage;
        } else {
            // 获取返回信息
            $result['status'] = 1;
            $result['msg'] = '发送成功';
        }

        return $result;
    }

    public function getSmsInfo()
    {
        return "Tencen SMS";
    }

    public function check_fee()
    {
        $str = '暂无接口！';
    }
}

?>