<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class vonage_sms
{
    var $sms;
    var $url;
    var $api_key;
    var $api_secret;
    var $from;

// 短信文档 https://developer.vonage.com/cn/messaging/sms/overview/curl
    public function __construct()
    {
        $this->url = 'https://rest.nexmo.com/sms/json';
        $sms_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "sms where is_effect = 1");
        if ($sms_info) {
            $sms_info['config'] = unserialize($sms_info['config']);

            $this->from = $sms_info['config'][0];
            $this->api_key = $sms_info['user_name'];
            $this->api_secret = $sms_info['password'];
        }
    }


    public function sendSms($mobiles, $content, $sendTime = '', $is_adv = 0, $code)
    {
        if (app_conf("SMS_ON") == 0) {
            return array(
                "status" => 0,
                "msg"    => '网站未开启短信功能',
            );
        }
        if (!is_array($mobiles))
            $mobiles = preg_split("/[ ,]/i", $mobiles);

        if (count($mobiles) > 0) {
            $url = $this->url;
            $para = array(
                'from'       => $this->from,
                'text'       => $content,
                'to'         => $mobiles[0],
                'api_key'    => $this->api_key,
                'api_secret' => $this->api_secret,
            );


            $result = $this->https_request($url, $para);

        } else {
            $result['status'] = 0;
            $result['msg'] = "没有发送的手机号";
        }

        return $result;
    }

    public function https_request($url, $para)
    {

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $para);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));//重点

        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($para));// post传输数据

        $response = curl_exec($ch);

        curl_close($ch);
        $data_val = json_decode($response, true);

        $data = array();
        if ($data_val['messages'][0]['status'] != 0) {
            $data['status'] = 0;
            $data['msg'] = $data_val['messages'][0]['error-text'];
        } else {
            $data['status'] = 1;
            $data['msg'] = 'OK';
        }
        return $data;
    }
}

?>