<?php
/**
 * @file: QueueApi.php
 * @desc: 消息队列入队列统一方法
 * 用法：
 * use App\Lib\QueueApi;
 * $QueueApi = new QueueApi();
 * $QueueApi->createQueueObj(key, key_num)->wait_queue(data);
 */

namespace utils\QueueApi;

class QueueApi
{

    /**
     * Redis 配置信息
     * @var array
     */
    protected $redis_config = [];

    /**
     * 队列配置
     * @var array
     */
    protected $queue_key = [];

    /**
     * Redis 实例对象
     * @var
     */
    protected $Redis;

    /**
     * 初始化
     */
    public function __construct()
    {
        $this->redis_config = [
            'host' => $GLOBALS['distribution_cfg']['RDB_CLIENT'],
            'password' => $GLOBALS['distribution_cfg']['RDB_PASSWORD'],
            'port' => $GLOBALS['distribution_cfg']['RDB_PORT'],
            'database' => $GLOBALS['distribution_cfg']['REDIS_PREFIX_DB'],
        ];
        bogo_require(APP_ROOT_PATH . 'system/utils/Credis.php');
        $this->Redis = \utils\Credis\CRedis::getInstance($this->redis_config, ['db_id' => $GLOBALS['distribution_cfg']['REDIS_PREFIX_DB'], 'timeout' => 3600]);
    }


    /**
     * 创建队列对象
     * @param $queue_key 队列监听key
     * @param $queue_num key个数
     */
    public function createQueueObj($queue_key, $data)
    {
        if (empty($queue_key)) return false;
        $this->Redis->rpush($queue_key, json_encode($data));
        return true;
    }
}