<?php

namespace utils;
class RequestUtils
{

    /**
     * 获取 GET 请求参数
     *
     * @param string $key     参数名
     * @param mixed  $default 默认值
     * @return mixed 参数值
     */
    public static function getGetParam($key, $default = null)
    {
        return isset($_GET[$key]) ? $_GET[$key] : $default;
    }

    /**
     * 获取 POST 请求参数
     *
     * @param string $key     参数名
     * @param mixed  $default 默认值
     * @return mixed 参数值
     */
    public static function getPostParam($key, $default = null)
    {
        return isset($_POST[$key]) ? $_POST[$key] : $default;
    }

    /**
     * 获取请求参数（优先获取 POST 参数，如果没有则获取 GET 参数）
     *
     * @param string $key     参数名
     * @param mixed  $default 默认值
     * @return mixed 参数值
     */
    public static function getRequestParam($key, $default = null)
    {
        return isset($_POST[$key]) ? $_POST[$key] : (isset($_GET[$key]) ? $_GET[$key] : $default);
    }

    /**
     * 获取所有 GET 请求参数
     *
     * @return array GET 请求参数数组
     */
    public static function getAllGetParams()
    {
        return $_GET;
    }

    /**
     * 获取所有 POST 请求参数
     *
     * @return array POST 请求参数数组
     */
    public static function getAllPostParams()
    {
        return $_POST;
    }

    /**
     * 获取所有请求参数（包括 GET 和 POST）
     *
     * @return array 请求参数数组
     */
    public static function getAllRequestParams()
    {
        return array_merge($_GET, $_POST);
    }
}
