<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class sms_sender
{
    var $sms;

    public function __construct()
    {
        $sms_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "sms where is_effect = 1");
        if ($sms_info) {
            $sms_info['config'] = unserialize($sms_info['config']);

            require_once APP_ROOT_PATH . "system/sms/" . $sms_info['class_name'] . "_sms.php";

            $sms_class = $sms_info['class_name'] . "_sms";
            $this->sms = new $sms_class($sms_info);
        }
    }


    public function sendSms($mobiles, $content, $sendTime = '', $is_adv = 0, $code)
    {
        if (app_conf("SMS_ON") == 0) {
            return array(
                "status" => 0,
                "msg"    => '网站未开启短信功能',
            );
        }
        if (!is_array($mobiles))
            $mobiles = preg_split("/[ ,]/i", $mobiles);

        if (count($mobiles) > 0) {
            if (!$this->sms) {
                $result['status'] = 0;
                $result['msg'] = "SMS not turned on";
            } else {
                $result = $this->sms->sendSms($mobiles, $content, $sendTime, $is_adv, $code);
            }
        } else {
            $result['status'] = 0;
            $result['msg'] = "No mobile phone number sent.";
        }

        return $result;
    }
}

?>