<?php
/**
 * 苹果验证类
 * Date: 2019/9/11
 */

use Firebase\JWT\JWK;
use Firebase\JWT\JWT;
use Firebase\JWT\SignatureInvalidException;

use Monolog\Logger;
use Monolog\Handler\StreamHandler;


const AUTH_KEYS_URL = 'https://appleid.apple.com/auth/keys'; //获取Apple公钥访问地址

class vendor_interface_apple
{

    /**
     * 验证token是否正常
     * 验证准确性：通过Apple公钥在线(https://8gwifi.org/jwkconvertfunctions.jsp)得到用于解密的pem公钥字符串
     * @param string $identityToken 前端获取的token
     * @return bool|object
     * @throws \Firebase\JWT\InvalidArgumentException
     */
    public function apple_jwt_verify($identityToken = '')
    {
        // create a log channel
        $log = new Logger('apple');
        $log->pushHandler(new StreamHandler('./log/apple_test.log', Logger::DEBUG));

        if (!$identityToken) {
            return false;
        }
        //取得下标值
        $subscript = 0;

        //获取apple认证秘钥 ：https://appleid.apple.com/auth/keys
        $data = file_get_contents(AUTH_KEYS_URL);

        if (is_null(json_decode($data))) {
            return false;
        }

        $public_key = json_decode($data, true);

        $log->info(json_encode($public_key));

        //获取公钥
        $pem = JWK::parseKeySet($public_key);

        $log->info('获取公钥:' . json_encode($pem));
        //$log->info(json_encode($pem[$kid]));


        // SignatureInvalidException
        for ($i = 0; $i < 3; $i++) {

            try {
                $alg = $public_key['keys'][$i]['alg'];
                $kid = $public_key['keys'][$i]['kid'];

                $log->info('打印参数:alg' . $alg . ' - kid=' . $kid);

                //返回包含**详情的数组
                $publicKey = openssl_pkey_get_details($pem[$kid]);

                $log->info('公钥KEY:' . $publicKey['key']);

                $decoded = JWT::decode($identityToken, $publicKey['key'], [$alg]);

            } catch (SignatureInvalidException $ex) {

            }

            if ($decoded) {
                break;
            }
        }

        if (!$decoded) {
            return false;
        }

        return $decoded;
    }

    /**
     * curl请求
     * @param $url
     * @param string $type
     * @param string $post_data
     * @return array
     */
    public function curl_request($url, $type = 'GET', $post_data = '')
    {

        $curl = curl_init();
        $aHeader = array();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);

        if ($type == 'POST') {
            $aHeader[] = 'Content-type: application/json';
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $post_data);
        }
        if (!empty($aHeader)) {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $aHeader);
        }

        curl_setopt($curl, CURLOPT_TIMEOUT, 120);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        $info = curl_getinfo($curl);
        $error_no = curl_errno($curl);
        $error_str = curl_error($curl);

        curl_close($curl);
        $result_array = json_decode($result, true);

        if ($info["http_code"] == 200) {
            $data = array(
                "code" => $info["http_code"],
                "data" => $result_array
            );
        } else {
            $data = array(
                "code" => $info["http_code"],
                "data" => array(
                    'time' => date('Y-m-d H:i:s', time()),
                    'type' => $type,
                    'url' => $url,
                    'post_data' => $post_data,
                    'code' => $info["http_code"],
                    'body' => $result_array,
                    'error_no' => $error_no,
                    'error_str' => $error_str
                )
            );
        }

        return $data;
    }

}